package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.qe.telemetry.metrics.yasm.YasmHistogram;
import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class InnerHistogramStatistics extends HistogramStatistics {
    private final Function<TDeployUnitSpec, Stream<Integer>> innerDeployUnitMetrics;

    public InnerHistogramStatistics(String name,
                                    Function<TDeployUnitSpec, Collection<Integer>> innerDeployUnitMetrics,
                                    Supplier<YasmHistogram> yasmHistogramSupplier) {
        super(name, null, metrics -> -1, yasmHistogramSupplier, StatisticsMode.ONLY_DU);
        this.innerDeployUnitMetrics = du -> innerDeployUnitMetrics.apply(du).stream();
    }

    @Override
    protected StatisticsResults<Integer> getStatResults(Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>> stages) {
        List<Integer> innerDeployUnitMetricResults =
                stages.values().stream()
                        .flatMap(stage -> stage.getSpec()
                                .getDeployUnitsMap().values().stream()
                                .flatMap(innerDeployUnitMetrics)
                        ).collect(Collectors.toList());

        Map<String, Integer> innerDeployUnitMetricMap = new HashMap<>();
        for (int i = 0; i < innerDeployUnitMetricResults.size(); i++) {
            innerDeployUnitMetricMap.put(i + "", innerDeployUnitMetricResults.get(i));
        }

        return new StatisticsResults<>(innerDeployUnitMetricMap, Map.of());
    }
}
