package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Map;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.infra.sidecars_updater.util.Utils;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class LabelGroupStatistics extends GroupStatistics<Long> {
    private final Function<Map.Entry<String, Map<String, YTreeNode>>, Map<String, Long>> labelMetric;

    public LabelGroupStatistics(String name,
                                Function<Map.Entry<String, Map<String, YTreeNode>>, Map<String, Long>> labelMetric,
                                StatisticsMode statisticsMode) {
        super(name, null, metrics -> -1L, statisticsMode);
        this.labelMetric = labelMetric;
    }

    @Override
    protected StatisticsResults<Long> getStatResults(Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>> stages) {
        return Utils.getLabelStatResults(stages, labelMetric, isDUStatistics());
    }
}
