package ru.yandex.infra.sidecars_updater.statistics;

import java.util.Map;

import ru.yandex.bolts.function.Function;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.infra.sidecars_updater.util.Utils;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class LabelStatistics extends GlobalStatistics {
    private final Function<Map.Entry<String, Map<String, YTreeNode>>, Map<String, Integer>> labelMetric;

    public LabelStatistics(String name,
                           Function<Map.Entry<String, Map<String, YTreeNode>>, Map<String, Integer>> labelMetric,
                           StatisticsMode statisticsMode) {
        super(name, null, metrics -> -1, Utils.countMetrics(), statisticsMode);
        this.labelMetric = labelMetric;
    }

    @Override
    protected StatisticsResults<Integer> getStatResults(Map<String, YpObject<StageMeta, TStageSpec, TStageStatus>> stages) {
        return Utils.getLabelStatResults(stages, labelMetric, isDUStatistics());
    }
}
