package ru.yandex.infra.sidecars_updater.util;

import java.util.Map;
import java.util.Objects;

import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class TStageAndDuId{
    private final YpObject<StageMeta, TStageSpec, TStageStatus> stage;
    private final String duId;

    public TStageAndDuId(YpObject<StageMeta, TStageSpec, TStageStatus> stage, String duId) {
        this.stage = stage;
        this.duId = duId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TStageAndDuId that = (TStageAndDuId) o;
        return stage.equals(that.stage) && duId.equals(that.duId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(stage, duId);
    }

    public YpObject<StageMeta, TStageSpec, TStageStatus> getStage() {
        return stage;
    }

    public String getDuId() {
        return duId;
    }

    public TDeployUnitSpec getDuSpec() {
        return stage.getSpec().getDeployUnitsMap().get(duId);
    }

    public Map<String, YTreeNode> getStageLabels() {
        return stage.getLabels();
    }
}
