JAVA_PROGRAM(sidecars_updater)

JDK_VERSION(11)

OWNER(
    panefgen
    g:deploy
    g:deploy-orchestration
)

INCLUDE(${ARCADIA_ROOT}/library/java/dependency_management.inc)

SET(COMMONS_IO_VERSION 2.4)
SET(JACKSON_VERSION 2.10.4)
SET(JACKSON_YAML_VERSION 2.9.8)
SET(TYPESAFE_CONFIG_VERSION 1.4.0)
SET(STREAMEX_VERSION 0.6.7)
SET(DISRUPTOR_VERSION 3.4.2)
SET(SLF4J_LOG4J_VERSION 2.16.0)

PEERDIR(
    infra/libs/java/controller/controller
    infra/stage_controller/proto

    yp/java/yp
    yp/yp_proto/yp/client/api/proto

    contrib/java/com/google/guava/guava/${GUAVA_VERSION}
    contrib/java/com/google/protobuf/protobuf-java-util

    # Needed by log4j2 for async logging
    # See https://logging.apache.org/log4j/2.x/manual/async.html
    contrib/java/com/lmax/disruptor/${DISRUPTOR_VERSION}

    contrib/java/com/fasterxml/jackson/core/jackson-databind/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml/${JACKSON_YAML_VERSION}

    contrib/java/com/typesafe/config/${TYPESAFE_CONFIG_VERSION}

    contrib/java/one/util/streamex/${STREAMEX_VERSION}

    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${SLF4J_LOG4J_VERSION}

    tracker/tracker-java-client/tracker-client/src/main
)

EXCLUDE(
    # some clashes inside iceberg-xml
    contrib/java/xml-apis/xml-apis
    contrib/java/log4j/log4j/1.2.17

    contrib/java/com/sun/activation/javax.activation/1.2.0
    contrib/java/commons-io/commons-io/2.0.1
    contrib/java/commons-logging/commons-logging
    contrib/java/org/apache/commons/commons-io/1.3.2
)

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/resources **/*)

UBERJAR()

UBERJAR_PATH_EXCLUDE_PREFIX(
    # fix for DEVTOOLS-5190, see also https://stackoverflow.com/a/6743609
    META-INF/DUMMY.DSA
    META-INF/DUMMY.SF
    META-INF/SAXONICA.RSA
    META-INF/SAXONICA.SF
    # fix for https://stackoverflow.com/q/34945438
    META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat
)

LINT(strict)

WITH_JDK()

NEED_CHECK()

END()

RECURSE(ut)
