#!/usr/bin/env bash

ENV="/usr/bin/env"
COMMON_PATH="/bin:/usr/bin"

trim() {
    local var="$*"
    var="${var#"${var%%[![:space:]]*}"}"
    var="${var%"${var##*[![:space:]]}"}"
    echo -n "$var"
}

if [[ ! -n "$3" ]]; then
  echo "Usage: $(basename $0) JDK_PATH VMOPTIONS_FILE cmd [arguments]" >&2
  exit 1
fi

if [[ ! -f "$2" ]]; then
  echo "File '$2' not exists" >&2
  exit 1
fi

JDK_PATH="$1"
shift

java_opts=()
ifs_tmp="${IFS}"
IFS=$'\n'
for opt in $(sed -e :a -e '/\\$/N;s/\\\n\s*//; ta' $1); do
    opt=$(trim "$opt")
    opt="${opt//[\"\']}"
    if [[ $opt != '#'* ]] && [[ "${opt}" != "" ]]; then
        java_opts+=("$opt")
    fi
done
shift

cmd=$1
shift

${ENV} \
    JAVA_HOME=${JDK_PATH} \
    JDK_HOME=${JDK_PATH} \
    PATH=${JDK_PATH}/bin:${COMMON_PATH} \
    "${cmd}" \
    "${java_opts[@]}" \
    "$@"
