package ru.yandex.infra.deploy;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadyServlet extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ReadyServlet.class);

    private Map<String, Deployer> deployers;

    public ReadyServlet(Map<String, Deployer> deployers) {
        this.deployers = deployers;
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        final PrintWriter writer = resp.getWriter();

        try {
            String stageCluster = req.getParameter("stage_cluster");
            String cluster = req.getParameter("cluster");
            String stage = req.getParameter("stage");
            String pod = req.getParameter("pod");
            int revision = Integer.parseInt(req.getParameter("revision"));

            var deployer = deployers.get(stageCluster + "." + stage);
            if (deployer != null) {
                deployer.workloadReady(cluster, revision, pod);
            }
            writer.println("ok");
        }
        catch (Exception exception) {
            LOG.error("Failed request", exception);
            writer.println(exception);
        }
    }
}
