#!/bin/sh

export DEBIAN_FRONTEND="noninteractive"
APT_GET="apt-get --yes --no-install-recommends"

apt-get update -y

# for dbus postinst
DIVERTS="usr/sbin/invoke-rc.d"
for file in $DIVERTS; do
	dpkg-divert --add --rename --local --divert /${file}.orig /${file}
	ln -s /bin/true $file
done
$APT_GET --force-yes install dbus
for file in $DIVERTS; do
	rm -f ${file}
	dpkg-divert --remove --rename /${file}
done

$APT_GET --force-yes install bash-completion \
        bc \
        bsdmainutils \
        bzip2 \
	ca-certificates \
        cpio \
        cryptsetup \
	curl \
        dc \
        dmsetup \
        ed \
        file \
        gawk \
        less \
	libcap2-bin \
	liblzo2-2 \
        libbsd0 \
	lsb-release \
        lvm2 \
	parted \
	perl \
	pciutils \
        procps \
        psmisc \
        python2.7 \
        openssl \
        strace \
        time \
        uuid-runtime \
        udev \
        xz-utils
