#!/bin/bash

set -xe
DIR=$(dirname $0)
pushd $DIR
# cd arcadia root
pushd ../../../

tmp=$(mktemp -d)
arc=$(pwd)
./ya make infra/diskmanager/{client,server,utils,ci/images/bionic/release/vm-image}

mkdir  $tmp/{bin,log,utils}
cp -L infra/diskmanager/client/dmctl       $tmp/bin
cp -L infra/diskmanager/server/diskmanager $tmp/bin
cp -L infra/diskmanager/utils/dqsync/dqsync $tmp/utils
cp -L infra/diskmanager/utils/remount/remount $tmp/utils

./ya tool vmexec -- \
     --mem 8G \
     -L $(mktemp -d ) \
     -I infra/diskmanager/ci/images/bionic/release/vm-image/rootfs.img \
     -v $YA_CACHE_DIR \
     -v $arc:/arcadia-arc \
     -v $tmp:/opt/diskmanager \
     -w /opt/diskmanager \
     --trap

rm -rf $tmp
