IF (NOT DISKMAN_TEST_IMAGE)
   MESSAGE(FATAL_ERROR 'DISKMAN_TEST_IMAGE' variable not defined)
ENDIF()

#######################

IF (AUTOCHECK)
    # Use released image
    SET(DISKMAN_TEST_IMAGE ${DISKMAN_TEST_IMAGE}/release)
ENDIF()
PY2TEST()

OWNER(dmtrmonakhov)

TEST_SRCS(
    test.py
)

DEPENDS(
    infra/diskmanager/ci/images/${DISKMAN_TEST_IMAGE}/vm-image
    infra/diskmanager/server
    infra/diskmanager/client
    infra/diskmanager/utils/dqsync
    infra/diskmanager/utils/remount
)

PEERDIR(
    infra/diskmanager/lib
    infra/diskmanager/ci/kvmtest/common
)

DATA(
    arcadia/library/recipes/qemu_kvm/images/keys
    arcadia/infra/diskmanager
)

SET(QEMU_ROOTFS infra/diskmanager/ci/images/${DISKMAN_TEST_IMAGE}/vm-image/rootfs.img)
SET(QEMU_SSH_USER root)
SET(QEMU_SSH_KEY library/recipes/qemu_kvm/images/keys/id_rsa)
SET(QEMU_MEM 3G)
SIZE(MEDIUM)
INCLUDE(${ARCADIA_ROOT}/library/recipes/qemu_kvm/recipe.inc)
END()
