#!/bin/bash


DIR=$(dirname $(realpath $0))
ARCADIA_ROOT=$DIR/../../..


# Prestable usualy with fresh kernel
sky list w@rtc.stage-prestable | sort -R | tail -n 3 > prestable_hosts.txt
# hahn-prestable usualy with older kernel
sky list W@rtc-yt-hahn-gpu-prestable | sort -R | tail -n 3 >> prestable_hosts.txt

set -xe
ya make -t \
   $ARCADIA_ROOT/infra/diskmanager/server \
   $ARCADIA_ROOT/infra/diskmanager/client

${ARCADIA_ROOT}/ya package \
	       --debian \
	       --not-sign-debian \
	       --custom-version=0.1-ci \
	       ${ARCADIA_ROOT}/infra/diskmanager/pkg/yandex-diskmanager/pkg.json

tmp=$(mktemp -d)
chmod +r $tmp
tar -zxvf yandex-diskmanager.0.1-ci.tar.gz  -C $tmp  yandex-diskmanager_0.1-ci_amd64.deb 

for h in $(cat prestable_hosts.txt | grep -v \#)
do
    scp $tmp/yandex-diskmanager_0.1-ci_amd64.deb $h:/tmp
done

sky run --hosts=prestable_hosts.txt "sudo dpkg -i /tmp/yandex-diskmanager_0.1-ci_amd64.deb"
sky run --hosts=prestable_hosts.txt "systemctl is-active yandex-diskmanager"
sky run --hosts=prestable_hosts.txt 'sudo dmctl list'
rm -rf $tmp
