DEFAULT_SERVER_UNIX_SOCK = '/run/yandex-diskmanager/yandex-diskmanager.sock'
DEFAULT_SERVER_ADDR = 'unix:' + DEFAULT_SERVER_UNIX_SOCK
DEFAULT_SOCKET_PERMISSIONS = 0o664
DEFAULT_SERVER_CONF = '/etc/yandex-diskmanager/diskmanager.conf'
DEFAULT_SERVER_LOG = '/var/log/yandex-diskmanager.log'
DEFAULT_YASM_PROD_URL = 'http://localhost:11005'
DEFAULT_YASM_PDOD_CTYPE = 'prod'
DEFAULT_YASM_PDOD_ITYPE = 'diskmanager'
DEFAULT_YASM_TEST_URL = 'http://localhost:100229'
DEFAULT_YASM_PUSH_PERIOD = 4.5
DEFAULT_FSTRIM_PERIOD = 600
DEFAULT_IO_SCHEDULER = "mq-deadline"
AVAIL_IO_SCHEDULERS = ["cfq", "bfq", "mq-deadline"]
# Max size is equals to flex group size 32Mb
DEFAULT_FSTRIM_MAX_CHUNK = 32 * 1024 * 1024
# Min size is equals to typical erasure SSD block
DEFAULT_FSTRIM_MIN_CHUNK = 128 * 1024
# Speed_factor X10, use
DEFAULT_FSTRIM_WAIT_FACTOR = 4
# sync quotas each hour
DEFAULT_QUOTA_SYNC_PERIOD = 3600
# Minimal possible iops bounds
DEFAULT_IOLIM_READ_IOPS_MIN = 10
DEFAULT_IOLIM_WRITE_IOPS_MIN = 10
DEFAULT_IOLIM_READ_BPS_MIN = 1024 ** 2
DEFAULT_IOLIM_WRITE_BPS_MIN = 1024 ** 2

# DISKMAN-122: set io limits on SAMSUNG MZWLL3T2HMJP-00003 and MZWLR7T6HALA-00007 disks
SAMSUNG_BAD_DISKS = ['SAMSUNG MZWLL3T2HMJP-00003', 'SAMSUNG MZWLR7T6HALA-00007']
SAMSUNG_IOLIM_WRITE_BPS = 640 * 1024 * 1024
SAMSUNG_MAX_SECTORS_KB = 16
SAMSUNG_DEFAULT_IOLIM_WRITE_BPS = 0
SAMSUNG_DEFAULT_MAX_SECTORS_KB = 128

# HOSTMAN-1345: enabling kyber
ENABLED_KYBER_MODELS_YT = []
ENABLED_KYBER_MODELS = []
ENABLED_KYBER_FOR_SSD = False
KYBER_OPTIONS = ('kyber', {'write_lat_nsec': '1000000000', 'read_lat_nsec': '1000000'})

# YP_export config with io-limits
DEFAULT_YP_EXPORT_IO_LIMITS_CONF = '/etc/yandex-diskmanager/io_limits.json'

DEFAULT_USER_ID = 0
DEFAULT_GROUP_ID = 1334
WIKI_URL = 'https://wiki.yandex-team.ru/runtime-cloud/disk-manager'
DOC_URL = 'https://a.yandex-team.ru/arc/trunk/arcadia/infra/diskmanager/README.md'

# storage device classes
STORAGE_HDD = 'hdd'
STORAGE_VIRT = 'virt'
STORAGE_SSD = 'ssd'
STORAGE_NVME = 'nvme'
STORAGE_NON_ROTATIONAL = (STORAGE_SSD, STORAGE_NVME)

SYSTEM_MOUNT_POINTS = ('/', '/home', '/place', '/ssd')
