import os
import sys
from infra.diskmanager.proto import diskman_pb2_grpc


class DiskManagerClient(object):
    """
    Wrapper for DiskManagerStub, append given metadata for each call
    """
    def __init__(self, channel, client_id='', metadata=[]):
        self.stub = diskman_pb2_grpc.DiskManagerStub(channel)
        self.metadata = metadata
        if not client_id:
            client_id = '%s:%d' % (os.path.basename(sys.argv[0]), os.getpid())
            self.metadata.append((b'client_id', client_id))

    def ServerInfo(self, req):
        return self.stub.ServerInfo(req, metadata=self.metadata)

    def ListDisks(self, req):
        return self.stub.ListDisks(req, metadata=self.metadata)

    def FormatDisk(self, req):
        return self.stub.FormatDisk(req, metadata=self.metadata)

    def ListVolumes(self, req):
        return self.stub.ListVolumes(req, metadata=self.metadata)

    def CreateVolume(self, req):
        return self.stub.CreateVolume(req, metadata=self.metadata)

    def DeleteVolume(self, req):
        return self.stub.DeleteVolume(req, metadata=self.metadata)

    def MountVolume(self, req):
        return self.stub.MountVolume(req, metadata=self.metadata)

    def UmountVolume(self, req):
        return self.stub.UmountVolume(req, metadata=self.metadata)

    def SetIOLimitVolume(self, req):
        return self.stub.SetIOLimitVolume(req, metadata=self.metadata)

    def GetHotSwapCreds(self, req):
        return self.stub.GetHotSwapCreds(req, metadata=self.metadata)

    def GetYTMountedDevices(self, req):
        return self.stub.GetYTMountedDevices(req, metadata=self.metadata)

    def DaemonGetStat(self, req):
        return self.stub.DaemonGetStat(req, metadata=self.metadata)

    def DaemonUpdateCache(self, req):
        return self.stub.DaemonUpdateCache(req, metadata=self.metadata)

    def DaemonSetLoglevel(self, req):
        return self.stub.DaemonSetLoglevel(req, metadata=self.metadata)
