import logging
import os

log = logging.getLogger('diskmanager.lib.kernel')


def safe_int(s, default=0):
    try:
        return int(s)
    except:
        pass
    return default


def kernel_version(krelease=None):
    major = 0
    minor = 0
    maint = 0
    internal = 0
    hotfix = 0

    if krelease is None:
        krelease = os.uname()[2]

    kt = krelease.split(".")
    if len(kt) >= 2:
        major = safe_int(kt[0])
        minor = safe_int(kt[1])
    if len(kt) >= 3:
        st = kt[2].split("-")
        maint = safe_int(st[0])
        if len(st) == 2:
            internal = safe_int(st[1])
    if len(kt) == 4:
        hotfix = safe_int(kt[3])
    return major, minor, maint, internal, hotfix
