#include <sys/quota.h>
#include <unistd.h>
#include <fcntl.h>

#ifndef USRQUOTA
#define USRQUOTA  0		/* element used for user quotas */
#endif

#ifndef GRPQUOTA
#define GRPQUOTA  1		/* element used for group quotas */
#endif

#ifndef PRJQUOTA
#define PRJQUOTA  2		/* element used for project quotas */
#endif

static int syncquotas(int type)
{
	int qcmd = QCMD(Q_SYNC, type);

	return quotactl(qcmd, NULL, 0, NULL);
}

int main()
{
	int ret = 0;

	if (syncquotas(USRQUOTA))
		ret =1;
	if (syncquotas(GRPQUOTA))
		ret = 2;
	if (syncquotas(PRJQUOTA))
		ret = 3;
	return ret;
}
