#define _FILE_OFFSET_BITS 64

#include <stdlib.h>
#include <err.h>
#include <sys/mount.h>
#include <sys/statvfs.h>
#include <string.h>
#include <stdio.h>

int main(int argc, char **argv)
{
	unsigned long flags;
	struct statvfs st;
	char *path;
        char *str, *token, *sptr;
	char *data, *dptr;

	if (argc != 3)
		errx(1, "usage: %s <path> <mount_options>", argv[0]);

	path = argv[1];
	if (statvfs(path, &st))
		err(2, "statvfs");

	flags = MS_REMOUNT;
	if (st.f_flag & ST_NOATIME)
		flags |= MS_NOATIME;
	if (st.f_flag & ST_NODIRATIME)
		flags |= MS_NODIRATIME;
	if (st.f_flag & ST_NODEV)
		flags |= MS_NODEV;
	if (st.f_flag & ST_NOEXEC)
		flags |= MS_NOEXEC;
	if (st.f_flag & ST_NOSUID)
		flags |= MS_NOSUID;
	if (st.f_flag & ST_RDONLY)
		flags |= MS_RDONLY;
	if (st.f_flag & ST_RELATIME)
		flags |= MS_RELATIME;
	if (st.f_flag & ST_SYNCHRONOUS)
		flags |= MS_SYNCHRONOUS;

	dptr = data = strdup(argv[2]);
	for (str = argv[2]; ; str = NULL) {
		token = strtok_r(str, ",", &sptr);
		if (token == NULL)
			break;
	        if (!strcmp(token, "noatime")) {
			flags |= MS_NOATIME;
		} else if (!strcmp(token,  "atime")) {
			flags &= ~MS_NOATIME;

		} else if (!strcmp(token, "nodiratime")) {
			flags |= MS_NODIRATIME;
		} else if (!strcmp(token, "diratime")) {
			flags &= ~MS_NODIRATIME;

		} else if (!strcmp(token, "nodev")) {
			flags |= MS_NODEV;
		} else if (!strcmp(token, "dev")) {
			flags &= ~MS_NODEV;

		} else if (!strcmp(token, "noexec")) {
			flags |= MS_NOEXEC;
		} else if (!strcmp(token, "exec")) {
			flags &= ~MS_NOEXEC;

		} else if (!strcmp(token, "nosuid")) {
			flags |= MS_NOSUID;
		} else if (!strcmp(token, "suid")) {
			flags &= MS_NOSUID;

		} else if (!strcmp(token, "ro")) {
			flags |= MS_RDONLY;
		} else if (!strcmp(token, "rw")) {
			flags &= ~MS_RDONLY;

		} else if (!strcmp(token, "relatime")) {
			flags |= MS_RELATIME;
		} else if (!strcmp(token, "norelatime")) {
			flags &= ~MS_RELATIME;

		} else if (!strcmp(token, "sync")) {
			flags |= MS_SYNCHRONOUS;
		} else if (!strcmp(token, "async")) {
			flags &= ~MS_SYNCHRONOUS;
		} else {
			int len = strlen(token);
			if (data != dptr)
				*dptr++ = ',';
			memcpy(dptr, token, len);
			dptr += len;
		}
	}
	*dptr = '\0';
	if (mount(NULL, path, NULL, flags, data))
		err(2, "mount");

	return 0;
}
