from __future__ import absolute_import
import os
import logging
from infra.dist.cacus.lib.daemon.duploader.worker import Worker
from infra.dist.cacus.lib.daemon.duploader.legacy import read_yandex_dinstall_config

log = logging.getLogger(__name__)


class DirectoryMakerWorker(Worker):
    def __init__(self, repos_conf):
        self.repos_conf = repos_conf

    def run(self):
        for repo, conf in self.repos_conf.iteritems():
            yndx_dinst_conf = read_yandex_dinstall_config(repo)
            if yndx_dinst_conf is not None and not yndx_dinst_conf:
                msg = ('Found yandex-dinstall config file, but cacus '
                       'option is not True. Ignoring.')
                log.info(msg)
                continue
            mode = 'compatibility' if yndx_dinst_conf else 'cacus_only'
            ensure_dirs = ['{}/../REJECT'.format(conf.incoming_dir), '{}/../work'.format(conf.incoming_dir), conf.incoming_dir]
            for d in ensure_dirs:
                if not os.path.exists(d):
                    os.makedirs(d)
            os.chmod(conf.incoming_dir, 01777)
            if mode == 'compatibility':
                yndx_dinst_path = '{}/../../yandex-dinstall/incoming'.format(
                    conf.incoming_dir
                )
                if not os.path.exists(yndx_dinst_path):
                    os.makedirs(yndx_dinst_path)
                    os.chmod(yndx_dinst_path, 01777)

    def cleanup(self):
        del self.repos_conf
