#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import absolute_import
import os
import logging
from infra.dist.cacus.lib.daemon.duploader.periodic_fs_watcher import PeriodicFSWatcher
from infra.dist.cacus.lib import common

log = logging.getLogger(__name__)


def start_duploader():
    conf = common.config.get('duploader_jobs_limits')
    pfw = PeriodicFSWatcher("/opt/repo", 5, 50, conf)
    try:
        pfw.run()
    except KeyboardInterrupt:
        log.info('keyboard interrupt... exiting...')
        os.kill(os.getpid(), 9)
        exit(13)
