import time
import sys
import traceback
import os
import ConfigParser
import logging
import infra.dist.cacus.lib.common
import infra.dist.cacus.lib.loader
from infra.dist.cacus.lib.dbal import keyring

log = logging.getLogger(__name__)

# legacy globals
keyring_cache = {}
keyring_cache_initialized = False
keyring_cache_rw_locks = {}
keyring_cache_timestamp = 0

KEYRING_CACHE_TTL = 60

barmaley_path = '/etc/barmaley'
barmaley_exists = os.path.exists(barmaley_path)
barmaley = open(barmaley_path).read().splitlines() if barmaley_exists else []


def update_keyring_cache(curr_cache, keyring_storage=keyring.default_storage):
    global keyring_cache_rw_locks
    keyrings_meta = keyring_storage.find(type_='group')

    for keyring_meta in keyrings_meta:
        center_group = keyring_meta.group
        if center_group == 'main_keyring':
            repos = 'main_keyring'
        else:
            repos = infra.dist.cacus.lib.common.config['gpg']['mapping'][center_group]

        if isinstance(repos, basestring):
            repos = [repos]
        for repo in repos:
            if repo not in keyring_cache_rw_locks:
                keyring_cache_rw_locks[repo] = infra.dist.cacus.lib.common.ReadWriteLock()

            new_or_changed = False
            if repo in curr_cache:
                cached_sha = curr_cache[repo]['sha256']
                if cached_sha != keyring_meta.sha256:
                    new_or_changed = True
            else:
                new_or_changed = True

            if new_or_changed:
                if repo not in curr_cache:
                    curr_cache[repo] = {}
                storage_key = keyring_meta.storage_key
                response = infra.dist.cacus.lib.loader.get_plugin('storage').get(storage_key)
                new_keyring = response.content
                keyring_cache_rw_locks[repo].acquire_write()
                filename = '/dev/shm/{}.gpg'.format(repo)
                f = open(filename, 'w+')
                f.write(new_keyring)
                f.close()
                curr_cache[repo]['keyring'] = filename
                curr_cache[repo]['sha256'] = keyring_meta.sha256
                keyring_cache_rw_locks[repo].release_write()
    return curr_cache


def keep_gpg_cache_fresh():
    global keyring_cache_initialized
    global keyring_cache
    global keyring_cache_timestamp
    log.debug('keep_gpg_cache_fresh start')
    try:
        if time.time() - keyring_cache_timestamp > KEYRING_CACHE_TTL:
            keyring_cache = update_keyring_cache(keyring_cache)
            keyring_cache_timestamp = time.time()
            keyring_cache_initialized = True
    except Exception as error:
        log.error('keep_gpg_cache_fresh: {}'.format(error))
        _, _, tb = sys.exc_info()
        log.error(traceback.format_exception(type(error), error, tb))
        return False
    return True


def read_yandex_dinstall_config(repo):
    config_path = '/etc/yandex-dinstall/{}.conf'.format(repo)
    if not os.path.exists(config_path):
        return None
    configp = ConfigParser.ConfigParser()
    configp.read(config_path)
    if configp.has_option('DEFAULT', 'cacus'):
        if configp.getboolean('DEFAULT', 'cacus'):
            return True
    return False
