import json
from infra.dist.cacus.lib.stats.synchronized_accumulator import SynchronizedAccumulator
from infra.dist.cacus.lib.stats.synchronized_histogram import SynchronizedHistogram

duploader_package_upload_timing_hgram_prev = [
    'duploader_package_upload_ahhh',
    (0, 0)
]
duploader_package_upload_timing_hgram = SynchronizedHistogram('duploader_package_upload_ahhh')
duploader_rejected_package_count = SynchronizedAccumulator('duploader_package_rejected_summ')
duploader_uploaded_package_count = SynchronizedAccumulator('duploader_package_uploaded_summ')
duploader_total_package_count = SynchronizedAccumulator('duploader_package_total_summ')
duploader_stale_rejects_removed_count = SynchronizedAccumulator('duploader_stale_rejects_removed_summ')
duploader_stale_work_removed_count = SynchronizedAccumulator('duploader_stale_work_removed_summ')
duploader_stale_incoming_removed_count = SynchronizedAccumulator('duploader_stale_incoming_removed_summ')


def dump_stats(file_path):
    global duploader_package_upload_timing_hgram_prev
    metric_list = [[
        duploader_rejected_package_count.name, duploader_rejected_package_count.get_value()
    ], [
        duploader_uploaded_package_count.name, duploader_uploaded_package_count.get_value()
    ], [
        duploader_total_package_count.name, duploader_total_package_count.get_value()
    ], [
        duploader_stale_rejects_removed_count.name, duploader_stale_rejects_removed_count.get_value()
    ], [
        duploader_stale_work_removed_count.name, duploader_stale_work_removed_count.get_value()
    ], [
        duploader_stale_incoming_removed_count.name, duploader_stale_incoming_removed_count.get_value()
    ]]
    if duploader_package_upload_timing_hgram.has_values():
        duploader_package_upload_timing_hgram_prev = [
            duploader_package_upload_timing_hgram.name,
            sorted(duploader_package_upload_timing_hgram.read_values().items(), key=lambda x: x[0])
        ]
    metric_list.append(duploader_package_upload_timing_hgram_prev)
    with open(file_path, 'w') as f:
        json.dump(metric_list, f)
