import logging

log = logging.getLogger(__name__)


class Worker(object):
    def __call__(self, *args, **kwargs):
        result = None
        try:
            result = self.run()
        except Exception:
            log.exception('got error running worker class: {}'.format(type(self)))
        finally:
            log.debug('cleaning up...')
            self.cleanup()
        return result

    def run(self):
        raise NotImplementedError('this method should be overridden')

    def cleanup(self):
        raise NotImplementedError('this method should be overridden')
