from __future__ import absolute_import


import tornado.httpserver
import tornado.ioloop
import tornado.netutil
import tornado.web
import tornado.log

from infra.dist.cacus.lib.daemon.stats.metrics_handler import MetricsHandler
from infra.dist.cacus.lib.daemon.stats.unistat_handler import UnistatHandler
import infra.dist.cacus.lib.common

signals = {}


def make_app():
    app = tornado.web.Application([
        (r'/unistat', UnistatHandler),
        (r'/metrics', MetricsHandler)
    ]
    )
    return app


def main():
    app = make_app()
    server = tornado.httpserver.HTTPServer(app)
    for port in infra.dist.cacus.lib.common.config['stats_daemon']['listen_ports']:
        sockets = tornado.netutil.bind_sockets(port)
        server.add_sockets(sockets)
    try:
        tornado.ioloop.IOLoop.current().start()
    except KeyboardInterrupt:
        tornado.ioloop.IOLoop.current().stop()
        tornado.log.app_log.warning('keyboard interrupt. exiting')
