from __future__ import absolute_import

import json
import tornado.web
import tornado.gen
import tornado.log
import tornado.httputil
import tornado.escape

from infra.dist.cacus.lib.stats.signal import Signal
from infra.dist.cacus.lib.stats.histogram import Histogram
from infra.dist.cacus.lib.stats.accumulator import Accumulator
from infra.dist.cacus.lib.stats.value import Value
import infra.dist.cacus.lib.daemon.stats.daemon


class MetricsHandler(tornado.web.RequestHandler):
    @tornado.gen.coroutine
    def get(self):
        self.set_status(405, 'this endpoint should be used only with POST')

    @tornado.gen.coroutine
    def post(self):
        try:
            tornado.log.app_log.debug('post body: {}'.format(self.request.body))
            json_repr = json.loads(tornado.escape.json_decode(self.request.body))
            json_repr = {str(k): v if not isinstance(v, unicode) else str(v) for k, v in json_repr.items()}
            tornado.log.app_log.debug('got json: {}:{}'.format(str(type(json_repr)), json_repr))
        except ValueError as error:
            tornado.log.app_log.error('cannot decode metrics json')
            tornado.log.app_log.error(error)
            self.send_error(500, reason='cannot decode metrics json: {}'.format(error))
            raise tornado.gen.Return()
        obj_fields = {str(s) for s in json_repr.keys()}
        if not obj_fields.issuperset(Signal.REQUIRED_FIELDS):
            self.send_error(
                500,
                reason='json has not all required fileds. REQUIRED_FIELDS: {}'.format(Signal.REQUIRED_FIELDS)
            )
            raise tornado.gen.Return()
        # check if we already have received signal
        if json_repr['name'] in infra.dist.cacus.lib.daemon.stats.daemon.signals.keys():
            signal = infra.dist.cacus.lib.daemon.stats.daemon.signals[json_repr['name']]
            if json_repr['type'] == str(Histogram):
                for v in json_repr['value']:
                    signal.put_value(float(v))
            elif json_repr['type'] == str(Accumulator):
                signal.put_value(float(json_repr['value']))
            elif json_repr['type'] == str(Value):
                signal.put_value(float(json_repr['value']))
        # signal is absent, create new one
        else:
            if json_repr['type'] == str(Histogram):
                signal = Histogram(json_repr['name'])
            elif json_repr['type'] == str(Accumulator):
                signal = Accumulator(json_repr['name'])
            elif json_repr['type'] == str(Value):
                signal = Value(json_repr['name'])
            else:
                error_string = 'got metrics of unknown type: {}'.format(json_repr['type'])
                tornado.log.app_log.error(error_string)
                self.send_error(500, reason=error_string)
        # set new signal value
            signal.start_measure()
            if isinstance(signal, Histogram):
                for v in json_repr['value']:
                    signal.put_value(float(v))
            elif isinstance(signal, Accumulator):
                signal.put_value(float(json_repr['value']))
            elif isinstance(signal, Value):
                signal.put_value(float(json_repr['value']))
            infra.dist.cacus.lib.daemon.stats.daemon.signals[json_repr['name']] = signal
        self.set_status(200)
        raise tornado.gen.Return()
