from __future__ import absolute_import

import json

import tornado.web
import tornado.gen
import tornado.log

from infra.dist.cacus.lib.stats.histogram import Histogram
from infra.dist.cacus.lib.stats.accumulator import Accumulator
from infra.dist.cacus.lib.stats.value import Value
import infra.dist.cacus.lib.daemon.stats.daemon


class UnistatHandler(tornado.web.RequestHandler):
    @tornado.gen.coroutine
    def get(self):
        unistat = []
        for signal in infra.dist.cacus.lib.daemon.stats.daemon.signals.values():
            signal.end_measure()
            if isinstance(signal, Histogram):
                # tornado.log.app_log.debug('histogram: {}'.format(signal.__dict__))
                if signal.has_values():
                    values = sorted(signal.read_values().items(), key=lambda x: x[0])
                else:
                    values = signal.zero_value()
                unistat.append(
                    [
                        signal.name,
                        values
                    ]
                )
                signal.reset_measure()
            elif isinstance(signal, Accumulator):
                unistat.append(
                    [
                        signal.name,
                        signal.get_value()
                    ]
                )
            elif isinstance(signal, Value):
                unistat.append(
                    [
                        signal.name,
                        signal.get_value()
                    ]
                )
            signal.start_measure()
        self.add_header('Content-type', 'application/json')
        self.set_status(200)
        self.write(json.dumps(unistat))
        raise tornado.gen.Return()
