from __future__ import absolute_import

import time
import socket
import logging

import infra.dist.cacus.lib.common
from infra.dist.cacus.lib.utils.push_metrics import push_metric
from infra.dist.cacus.lib.stats.histogram import Histogram
from infra.dist.cacus.lib.stats.value import Value
log = logging.getLogger(__name__)

local_metrics = {
    'zk_avg_latency': Histogram('zk_avg_latency_ahhh'),
    'zk_max_latency': Histogram('zk_max_latency_ahhh'),
    'zk_num_alive_connections': Value('zk_num_alive_connections_ammm'),
    'zk_znode_count': Value('zk_znode_count_attt'),
    'zk_open_file_descriptor_count': Value('zk_open_file_descriptor_count_ammm'),
    'zk_outstanding_requests': Value('zk_outstanding_requests_ammm')
}


def main():
    metrics_url = infra.dist.cacus.lib.common.config['zk_stats_daemon']['stats_push_url']
    while True:
        try:
            sock = socket.socket(socket.AF_INET6, socket.SOCK_STREAM, socket.IPPROTO_TCP)
            sock.connect(('::1', int(infra.dist.cacus.lib.common.config['distributed_locks']['zk_port'])))
            log.info('opened zookeeper connection')
            sock.sendall('mntr')
            time.sleep(0.1)
            reply = sock.recv(4096)
            sock.close()
            log.info('closed zookeeper connection...')
            zk_status_values_list = reply.splitlines(False)
            log.debug('got lines from zk: {}'.format(zk_status_values_list))
            zk_metrics = dict()
            for line in zk_status_values_list:
                val = line.split()
                zk_metrics[val[0].strip()] = val[1].strip()
            for metric, value in local_metrics.items():
                value.reset_measure(True)
                value.start_measure()
                value.put_value(float(zk_metrics[metric]))
                value.end_measure()
                push_metric(metrics_url, value.to_json())
            time.sleep(1)
        except KeyboardInterrupt:
            log.warning('keyboard interrupt exiting...')
            exit(13)
        except Exception as error:
            log.error('got unexpected error running zk_stats-daemon')
            log.error('{}: {}'.format(type(error), error))
