from infra.dist.cacus.lib.dbal import mongo_connection


class LegacyDeletedKeyStore(object):
    COLLECTION = '__to_delete__'

    def __init__(self, db_fun=mongo_connection.cacus):
        self.db = db_fun

    def push(self, key):
        self.db()[self.COLLECTION].update(
            {'name': 'failed_to_delete'},
            {'$addToSet': {'keys': key}},
            upsert=True
        )

    def pop(self, key):
        self.db()[self.COLLECTION].update(
            {'name': 'failed_to_delete'},
            {'$pull': {'keys': key}},
        )

    def all(self):
        r = self.db()[self.COLLECTION].find_one(
            {'name': 'failed_to_delete'}
        )
        if r:
            return r['keys']
        else:
            return []


default_store = LegacyDeletedKeyStore()
