from infra.dist.cacus.lib.dbal import errors
from infra.dist.cacus.lib.dbal import mongo_connection

COLLECTION = '__gpg__'


class KeyringStorage(object):
    def __init__(self, db_func=mongo_connection.cacus):
        self.db = db_func

    @staticmethod
    def _find_query(group=None, type_=None):
        q = {}
        if group:
            q['center_group'] = group
        if type_:
            q['type'] = type_
        return q

    def find_one(self, group=None, type_=None):
        rv = self.db()[COLLECTION].find_one(self._find_query(group, type_))
        if rv:
            return Keyring.from_dict(rv)
        else:
            return None

    def find(self, group=None, type_=None):
        rv = []
        for r in self.db()[COLLECTION].find(self._find_query(group, type_)):
            rv.append(Keyring.from_dict(r))
        return rv

    def save(self, k):
        r = self.db()[COLLECTION].update_one({'center_group': k.group}, {'$set': k.to_dict()},
                                             upsert=True)
        if r.upserted_id is None and r.matched_count != 1:
            raise errors.KeyringNotSaved('cannot save keyring for group "{}", matched: {}, upserted: {}'.format(
                k.group, r.matched_count, r.upserted_id
            ))


class Keyring(object):
    def __init__(self, group, type_, storage_key, sha256, size):
        self.size = size
        self.sha256 = sha256
        self.storage_key = storage_key
        self.type = type_
        self.group = group

    @classmethod
    def from_dict(cls, d):
        return cls(
            d['center_group'],
            d['type'],
            d['storage_key'],
            d['sha265'],
            d['size']
        )

    def to_dict(self):
        return {
            'center_group': self.group,
            'type': self.type,
            'storage_key': self.storage_key,
            'sha265': self.sha256,
            'size': self.size,
        }

    def __str__(self):
        return str(self.to_dict())

    def __repr__(self):
        return self.__str__()


default_storage = KeyringStorage()
