from infra.dist.cacus.lib.dbal import mongo_connection


class UpstreamStore(object):
    COLLECTION = '__upstream_packages__'

    def __init__(self, db_fun=mongo_connection.cacus):
        self.db = db_fun

    @staticmethod
    def _find_query(dist=None, package=None):
        q = {}
        if dist:
            q['dist'] = dist
        if package:
            q['package'] = package
        return q

    def find(self, dist=None, package=None):
        return [UpstreamPackage.from_dict(d) for d in self.db()[self.COLLECTION].find(self._find_query(dist, package))]

    def find_one(self, dist=None, package=None):
        r = self.db()[self.COLLECTION].find_one(self._find_query(dist, package))
        if r:
            return UpstreamPackage.from_dict(r)
        else:
            return None

    def list_dists(self):
        return self.db()[self.COLLECTION].distinct('dist')

    def save(self, up):
        q = self._find_query(up.dist, up.package)
        self.db()[self.COLLECTION].update_one(q, {'$set': up.to_dict()}, upsert=True)


class UpstreamPackage(object):
    def __init__(self, dist, package):
        self.package = package
        self.dist = dist

    @classmethod
    def from_dict(cls, d):
        return cls(d['dist'], d['package'])

    def to_dict(self):
        return {
            'dist': self.dist,
            'package': self.package,
        }


default_store = UpstreamStore()
