import base64

head_strings = [
    "BEGIN PGP MESSAGE",
    "BEGIN PGP PUBLIC KEY BLOCK",
    "BEGIN PGP SIGNATURE",
    "BEGIN PGP SIGNED MESSAGE",
    "BEGIN PGP ARMORED FILE",  # gnupg extension
    "BEGIN PGP PRIVATE KEY BLOCK",
    "BEGIN PGP SECRET KEY BLOCK",  # only used by pgp2
]
tail_strings = [
    "END PGP MESSAGE",
    "END PGP PUBLIC KEY BLOCK",
    "END PGP SIGNATURE",
    "END dummy",
    "END PGP ARMORED FILE",
    "END PGP PRIVATE KEY BLOCK",
    "END PGP SECRET KEY BLOCK"
]

armor_tags = [
    "Version",
    "Comment",
    "MessageID",
    "Hash",
    "Charset"
]

'''
In my opinion, the proper way to dearmor keys is like this:
'''

# def split_crc(key):
#     key_length = len(key) - 1
#     idx = key_length
#     while key[idx] != "=" and idx >= 0:
#         idx -= 1
#     if idx == 0:
#         return key
#     else:
#         return key[:idx]

# def remove_headers(key):
#     lines = key.splitlines()
#     header_delimiter = "-----"
#     line_num = 0
#     for line_num, line in enumerate(lines):
#         for header_num, head_string in enumerate(head_strings):
#             header_phrase = "{}{}{}".format(
#                 header_delimiter,
#                 head_string,
#                 header_delimiter)
#             if header_phrase in line:
#                 lines[line_num] = lines[line_num].replace(
#                     header_phrase, "")
#                 tail_phrase = "{}{}{}".format(
#                     header_delimiter,
#                     tail_strings[header_num],
#                     header_delimiter)
#                 for idx in reversed(xrange(line_num, len(lines))):
#                     if tail_phrase in lines[idx]:
#                         lines[idx] = lines[idx].replace(tail_phrase, "")
#                         break
#                 else:
#                     raise ValueError(
#                         'Not found closing header for "{}"'.format(
#                             head_string
#                         )
#                     )
#     return lines


# def remove_tags(key_lines):
#     for line_num, line in enumerate(key_lines):
#         for armor_tag in armor_tags:
#             if line.find(armor_tag) == 0:
#                 key_lines[line_num] = ""
#     return key_lines

# def dearmor_key(dirty_key):
#     headerless_key = remove_headers(dirty_key)
#     tagless_key = remove_tags(headerless_key)
#     key_text = '\n'.join(filter(None, tagless_key))
#     clean_key = split_crc(key_text).rstrip('\n')
#     dearmored = bytearray(base64.b64decode(clean_key))
#     return dearmored

'''
But we are in real world, and in gnupg it is done like this:
'''


def remove_headers(key):
    clean_key = ""
    key_begined = False
    have_some_header = False
    lines = key.splitlines()
    for line in lines:
        line = line.rstrip('\r')
        line = line.rstrip()
        if not line:
            continue
        if line[0] == '-' and not key_begined:
            if filter(lambda head_string: head_string in line, head_strings):
                have_some_header = True
            continue
        elif line[0] == '-':
            if filter(lambda tail_string: tail_string in line, tail_strings):
                continue

        # crc encountered
        if line[0] == '=' and key_begined:
            break

        cont = False
        for armor_tag in armor_tags:
            if line.find(armor_tag) == 0:
                cont = True
                break
        if cont:
            continue

        if have_some_header:
            key_begined = True
            equal_sign_pos = line.rfind("=")
            if equal_sign_pos == -1:
                clean_key += line + "\n"
            else:
                if line[len(line) - 1] != "=":
                    clean_key += line[:equal_sign_pos]
                else:
                    clean_key += line + "\n"

    return clean_key.rstrip('\n')


def dearmor_key(dirty_key):
    clean_key = remove_headers(dirty_key)
    dearmored = bytearray(base64.b64decode(clean_key))
    return dearmored


if __name__ == "__main__":
    import binascii

    key = '''-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.11 (GNU/Linux)

mQENBFWdFR8BCADGHomntdebLfMXt/SHDzslmL42xL2HOpbrN5aBgG15AO+nQ2/w
UZNbH039iU6bJ3nVp0C/bmGSfDo06+ix1p0VZHvvuHTSU7CRRTsYc9VKOPtkNhnE
HF7hFqJWVL5QkXvudu+OUtWQ+9PBhg0FyQyDeVbjxxDfcLuuEXlqriCELG6eYFNZ
mgKo/a9PbaFUXVWsR5J0Fo/NJg3jhoKhdmMyxCuLEtTyrEBF80UmpVTf9SS6HKjP
ajyNiSO94wz479yBS1Q38iBMn4IKZ+13MMbZnvcDpINMSbubvs/Vc8bopCFjuheb
Ypm3XXL6aw/Gb/iFBUOy7xwwsXkG9b/AwYVlABEBAAG0JVNlcmdleSBFZmltb3Yg
PHp5bmFwc0B5YW5kZXgtdGVhbS5ydT6JATgEEwECACIFAlWdFR8CGwMGCwkIBwMC
BhUIAgkKCwQWAgMBAh4BAheAAAoJEC32cQtTXWIFT6UH/0CzTrP4VYCYkC7cotYD
QdUM54blCruy63MZEaPjStkiK5WtaLkCaOosxM0NLwMbt36kRihi+dwKHLM66Bee
GfzX5oWW1WUxpojIISIyojvdxA/qSyBq9lgmTpu4PnEo7jDJjxeJcWSdVokYBus0
d/slEAK89g0EHVhTcQ7txOQrrkapRNuvSwIsRPDrVcymbg5AZLMY+UqPBvb/98Dd
MZUNvw5UhT9/NbXzgiye7YJnKMsoz6Z66NtYg/QZxxz8AniCPgPcNDbh4ZHDeO3u
RyFde9n3nkrGviFwwT7trh3L8FIrAluPa0FDdL9LJQcVtFbNmFhtFrfOzXeSbC76
+8S5AQ0EVZ0VHwEIALcHSQyP8jU9xOZCMLpev78voWf5abRB/sBeAHxPtz+y0MeN
dbmVMdSoPhI5oQyNH/7RpClP0YxjpXxn7MKGyOqBnMdRmmzl8SKu/Its6UasWRd1
AMbzu0WmHYarZ7cN2ZrBMUF2OObVOc0JtvU28UV/Yb5NlWAELrV+N1fgJ1mt5CJg
rdsC1eDIRaiKrri5j9e+MSG680ekKQdwAQ7PA0TAqeN4HoYvpcn43rhapGkvDNId
9mZRvFwfU6yjck0EveZS1ZkeZZg912bgxPBySCPi4563FpTRq9CVqonXcHyxVwCH
QOt39JmctRIWckr08P7VZ0jrU7mhkcwWVjNIeEsAEQEAAYkBHwQYAQIACQUCVZ0V
HwIbDAAKCRAt9nELU11iBTvWB/sHFlMfvHwYq7kHABsFDBaPM5OTdJ/WWrlYP3zS
gShAN39oLHUlSccGqZH4/DZxpoE8nv/RH4lkiP5DoLYn2Xf7JkJnrssN1X3uFdrX
zTyE7b1+zBvj86o1rR75U9tg+ihINLFnxDE67D+Too9GaMU8RZr7e1vdPXMYNsZk
ID0Zcsk4vkkWJATsRKICtn2c/6RRb1HqFpT04QUqOVvXX5ol3JEoDjG8noLtb/cq
CCSbdICWL4lfGyBGqKRmg7esBet6kK3D5Vj7aq1YhEleMIYWesCNkNlZkdm4GrQA
tcmfOD3QcVp4CrTvfcPD/3DhzDj05d49HcHLZeLwgwxHpHNW
=ZlJn
-----END PGP PUBLIC KEY BLOCK-----
'''

    dearmored = dearmor_key(key)

    if binascii.crc32(dearmored) == 769917952:
        print "Seems to be working well."
    else:
        raise Exception("Something went wrong during dearmoring!")
