from datetime import datetime
from pprint import PrettyPrinter

import re

dmove_log_line_patt = r'(?P<unix_time>\d*) ' \
                      r'(?P<date>.*\d{2}:\d{2}:\d{2} [A-Z]{3} \d{4}): ' \
                      '(?P<user>.*) : ' \
                      '(?P<repo>.*) ' \
                      '(?P<pkg>.*) ' \
                      '(?P<ver>.*) ' \
                      '(?P<src>.*) -> ' \
                      '(?P<dst>.*)'
dmove_log_line_re = re.compile(dmove_log_line_patt)


class DmoveAction(object):
    def __init__(self, dt, repo, pkg, ver, src, dst):
        self.dt = dt
        self.repo = repo
        self.pkg = pkg
        self.ver = ver
        self.src = src
        self.dst = dst

    def __repr__(self):
        return 'Date: {}, repo: {}, package: {}, version: {},' \
               ' source: {}, destination: {}'.format(
            self.dt,
            self.repo,
            self.pkg,
            self.ver,
            self.src,
            self.dst
        )


def parse_dmove_log(filename):
    log = []
    log_lines = open(filename).read().split('\n')
    for line_num, log_line in enumerate(log_lines):
        log_match = dmove_log_line_re.match(log_line)
        if log_match:
            unix_time = int(log_match.group("unix_time"))
            repo = log_match.group("repo")
            pkg = log_match.group("pkg")
            ver = log_match.group("ver")
            src = log_match.group("src")
            dst = log_match.group("dst")
            dt = datetime.fromtimestamp(unix_time)
            dmove_action = DmoveAction(dt, repo, pkg, ver, src, dst)
            log.append(dmove_action)
        else:
            raise ValueError(
                'Cannot parse line {}! of file: {} \n Line content: {}'.format(
                    line_num, filename, log_line
                )
            )
    return log


if __name__ == "__main__":
    pp = PrettyPrinter(indent=4)
    pp.pprint(parse_dmove_log('/var/log/dmove.log'))
