#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import infra.dist.cacus.lib.common
import infra.dist.cacus.lib.plugins.MDSStorage

loaded_plugins = {}
log = logging.getLogger(__name__)


def load_plugins():
    if 'storage' not in loaded_plugins:
        mds = infra.dist.cacus.lib.plugins.MDSStorage.MDSStorage()
        mds.configure(infra.dist.cacus.lib.common.config['storage'])
        loaded_plugins['storage'] = mds


def get_plugin(category):
    log.debug('loaded plugins: {}'.format(loaded_plugins))
    return loaded_plugins[category]
