#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from infra.dist.cacus.lib import plugins


class FileStorage(plugins.IStoragePlugin):

    def configure(self, config):
        self.root = config['path']
        os.mkdir(self.root) if not os.path.isdir(self.root) else None

    def put(self, key, filename=None, file=None):
        if filename:
            file = open(filename, 'rb')
        newpath = os.path.join(self.root, key)
        try:
            os.makedirs(os.path.dirname(os.path.abspath(newpath)))
        except OSError as e:
            if e.errno != 17:
                raise

        with open(newpath, 'wb+') as new_f:
            with file as old_f:
                old_f.seek(0, os.SEEK_END)
                old_f.seek(0)
                while True:
                    piece = old_f.read(4096)
                    if not piece:
                        break
                    new_f.write(piece)
        return newpath

    def get(self, key):
        return os.path.join(self.root, key)

    def complete_url_regex(self, url_re):
        return r"/storage/(?P<couple_id>\d+)/{}".format(url_re)
