from __future__ import absolute_import
from infra.dist.cacus.lib.stats.signal import Signal


class Accumulator(Signal):
    def __init__(self, name):
        Signal.__init__(self, name)
        self.value = 0
        self._has_values = False

    def put_value(self, value):
        self._has_values = True
        self.value += value

    def get_value(self):
        return self.value

    def reset_measure(self, force=False):
        self.value = 0
        self._has_values = False

    def has_values(self):
        return self._has_values
