import json


class Signal(object):
    REQUIRED_FIELDS = {'name', 'type', 'value'}

    def __init__(self, signal_name):
        self.name = signal_name

    def put_value(self, value):
        raise NotImplementedError('method Signal.put_value should be overriden')

    def get_value(self):
        raise NotImplementedError('method Signal.get_value should be overriden')

    def start_measure(self):
        pass

    def end_measure(self):
        pass

    def reset_measure(self, force=False):
        pass

    def has_values(self):
        pass

    def to_json(self):
        json_repr = {
            'name': self.name,
            'type': str(type(self)),
            'value': self.get_value()
        }
        return json.dumps(json_repr)

    @classmethod
    def from_json(cls, json_string):
        raise NotImplementedError('class method Signal.from_json should be overriden')
