from __future__ import absolute_import
from infra.dist.cacus.lib.stats.accumulator import Accumulator
import infra.dist.cacus.lib.utils.lockable


class SynchronizedAccumulator(Accumulator, infra.dist.cacus.lib.utils.lockable.SerializedAccess):
    def __init__(self, name):
        Accumulator.__init__(self, name)
        infra.dist.cacus.lib.utils.lockable.SerializedAccess.__init__(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def put_value(self, value):
        return Accumulator.put_value(self, value)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def get_value(self):
        return Accumulator.get_value(self)
