from __future__ import absolute_import
from infra.dist.cacus.lib.stats.histogram import Histogram
import infra.dist.cacus.lib.utils.lockable


class SynchronizedHistogram(Histogram, infra.dist.cacus.lib.utils.lockable.SerializedAccess):
    def __init__(self, name):
        Histogram.__init__(self, name)
        infra.dist.cacus.lib.utils.lockable.SerializedAccess.__init__(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def start_measure(self):
        return Histogram.start_measure(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def end_measure(self):
        return Histogram.end_measure(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def read_values(self):
        return Histogram.read_values(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def reset_measure(self):
        return Histogram.reset_measure(self)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def put_value(self, value):
        return Histogram.put_value(self, value)

    @infra.dist.cacus.lib.utils.lockable.serialized_method
    def has_values(self):
        return Histogram.has_values(self)
