from __future__ import absolute_import
import time


def callable_timing_hram(histogram):
    def decorator(wrapped):
        def wrapper(*args, **kwargs):
            start_time = time.time()
            result = wrapped(*args, **kwargs)
            end_time = time.time()
            histogram.put_value((end_time - start_time) * 1000)     # multiply 1000 to get milliseconds
            return result
        return wrapper

    return decorator
