from __future__ import absolute_import
from infra.dist.cacus.lib.stats.signal import Signal


class Value(Signal):
    def __init__(self, name, default=0.0):
        Signal.__init__(self, name)
        self.value = default
        self._has_values = False
        self.__default = default

    def put_value(self, value):
        self._has_values = True
        self.value = value

    def get_value(self):
        return self.value

    def reset_measure(self, force=False):
        self.value = self.__default
        self._has_values = False

    def has_values(self):
        return self._has_values
