from __future__ import absolute_import
import time
import logging


class PackageFilter(object):
    log = None

    def __init__(self, repo, env, package, keep_last_versions, keep_versions, keep_time):
        if PackageFilter.log is None:
            PackageFilter.log = logging.getLogger('infra.dist.cacus.lib.tools.repo-cleaner.packageFilter')
        self.repo = repo
        self.env = env
        self.package = package
        self.keep_versions = keep_versions
        if isinstance(keep_last_versions, str):
            if keep_last_versions == 'any':
                self.keep_last_versions = 200000000000
        else:
            self.keep_last_versions = keep_last_versions
        if isinstance(keep_time, str):
            if keep_time == 'any':
                self.keep_time = 200000000000   # very long time...
        else:
            self.keep_time = keep_time
        self._last_version = None
        self._versions_seen = 0
        # import pdb
        # pdb.set_trace()

    def filter(self, repo, env, package, version, btime):
        """
        Check package for removal
        :param repo:
        :param env:
        :param package:
        :param version:
        :param btime:
        :return: True if package should be removed, False otherwise
        """
        PackageFilter.log.debug('filter(%s, %s, %s, %s, %s): called', repo, env, package, version, btime)
        package_filtered = False
        current_time = time.time()
        if self._last_version is None:
            self._last_version = version
        if version > self._last_version:
            PackageFilter.log.error('filter(%s, %s, %s, %s, %s):', repo, env, package, version, btime)
            PackageFilter.log.error('last version: %s', self._last_version)
            PackageFilter.log.error('current version: %s', version)
            raise ValueError('packages sorting violation')
        if repo != self.repo:
            raise ValueError('package repo mismatch')
        if env != self.env:
            raise ValueError('package env mismatch')
        if package != self.package:
            raise ValueError('package name mismatch')
        if version in self.keep_versions:
            PackageFilter.log.debug('filter(%s, %s, %s, %s, %s): explicit version to keep', repo, env, package, version,
                                    btime)
            return False
        if current_time - self.keep_time > btime:
            package_filtered = True
        # import pdb
        # pdb.set_trace()
        if self._versions_seen >= self.keep_last_versions:
            package_filtered = True
        self._versions_seen += 1
        PackageFilter.log.debug('filter(%s, %s, %s, %s, %s): versions_seen: %s', repo, env, package, version, btime, self._versions_seen)
        PackageFilter.log.debug('filter(%s, %s, %s, %s, %s): package_filtered: %s', repo, env, package, version, btime, package_filtered)
        return package_filtered
