from __future__ import absolute_import
from infra.dist.cacus.lib.tools.repo_cleaner.package_filter import PackageFilter


class PackageFilterFactory(object):
    def __init__(self, filter_config):
        self.filter_config = filter_config
        self.prepared_filters = {}

    def get_filter(self, repo, env, package):
        package_path = [repo, env, package]
        if repo is None or env is None or package is None:
            raise ValueError('cannot get filter for requested package')
        filter_instance = self.__path_get(self.prepared_filters, package_path)
        if filter_instance is not None:
            return filter_instance
        else:
            keep_versions = []
            keep_last_versions = self.filter_config['defaults']['keep_last_versions']
            keep_time = self.filter_config['defaults']['keep_time']
            if 'packages' in self.filter_config['defaults']:
                if package in self.filter_config['defaults']['packages']:
                    keep_last_versions = self.filter_config['defaults']['packages'][package].get('keep_last_versions') or keep_last_versions
                    keep_time = self.filter_config['defaults']['packages'][package].get('keep_time') or keep_time
                    if 'keep_versions' in self.filter_config['defaults']['packages'][package]:
                        keep_versions.extend(self.filter_config['defaults']['packages'][package]['keep_versions'])

            if env in self.filter_config['defaults']['branches']:
                current = self.filter_config['defaults']['branches'][env]
                keep_last_versions = current.get('keep_last_versions') or keep_last_versions
                keep_time = current.get('keep_time') or keep_time
                if 'packages' in current:
                    if package in current['packages']:
                        keep_last_versions = current['packages'][package].get('keep_last_versions') or keep_last_versions
                        keep_time = current['packages'][package].get('keep_time') or keep_time
                        if 'keep_versions' in current['packages'][package]:
                            keep_versions.extend(current['packages'][package]['keep_versions'])

            if repo in self.filter_config['repos']:
                keep_last_versions = self.filter_config['repos'][repo].get('keep_last_versions') or keep_last_versions
                keep_time = self.filter_config['repos'][repo].get('keep_time') or keep_time

                if 'packages' in self.filter_config['repos'][repo]:
                    if package in self.filter_config['repos'][repo]['packages']:
                        keep_last_versions = self.filter_config['repos'][repo]['packages'][package].get(
                            'keep_last_versions') or keep_last_versions
                        keep_time = self.filter_config['repos'][repo]['packages'][package].get('keep_time') or keep_time
                        if 'keep_versions' in self.filter_config['repos'][repo]['packages'][package]:
                            keep_versions.extend(self.filter_config['repos'][repo]['packages'][package]['keep_versions'])

                if 'branches' in self.filter_config['repos'][repo]:
                    if env in self.filter_config['repos'][repo]['branches']:
                        current = self.filter_config['repos'][repo]['branches'][env]
                        keep_last_versions = current.get('keep_last_versions') or keep_last_versions
                        keep_time = current.get('keep_time') or keep_time
                        if 'packages' in current:
                            if package in current['packages']:
                                keep_last_versions = current['packages'][package].get(
                                    'keep_last_versions') or keep_last_versions
                                keep_time = current['packages'][package].get('keep_time') or keep_time
                                if 'keep_versions' in current['packages'][package]:
                                    keep_versions.extend(current['packages'][package]['keep_versions'])
            filter_instance = PackageFilter(repo, env, package, keep_last_versions, keep_versions, keep_time)
            self.__path_put(self.prepared_filters, package_path, filter_instance)
        return filter_instance

    def __path_get(self, hash, path):
        result = hash
        for breadcrumb in path[:-1]:
            if result is None:
                break
            result = result.get(breadcrumb)
        if result is not None:
            return result.get(path[-1])
        return None

    def __path_put(self, hash, path, value):
        current = hash
        for breadcrumb in path[:-1]:
            if breadcrumb not in current:
                current[breadcrumb] = {}
            current = current[breadcrumb]
        current[path[-1]] = value
