from __future__ import absolute_import
import threading


class SerializedAccess(object):
    def __init__(self):
        self._serialized_lock = threading.Lock()


def serialized_method(method):
    def wrapper(self, *args, **kwargs):
        with self._serialized_lock:
            result = method(self, *args, **kwargs)
        return result

    return wrapper
