import os
import logging
import time

log = logging.getLogger(__name__)


def terminate_child(child, child_type):
    try:
        child.terminate()
    except OSError:
        log.exception('failed to terminate {} process {}'.format(child_type, child.pid))
    time.sleep(1)
    if child.is_alive():
        log.error('{} process refused SIGTERM, sending SIGKILL'.format(child_type))
        try:
            os.kill(child.pid, 9)
        except OSError:
            log.exception('failed to kill {} process {}'.format(child_type, child.pid))
