from __future__ import absolute_import
import requests
import logging

log = logging.getLogger(__name__)


def push_metric(address, metrics):
    log.debug('pushing metric {} to {}'.format(metrics, address))
    try:
        requests.post(address, json=metrics, timeout=0.1)
    except Exception as error:
        log.error('cannot push metric {} to {}'.format(metrics, address))
        log.error(error)
        return False
    return True
