import yaml

default_config = """
user: loadbase
group: www-data
programName: Yandex.Repo package driver (dmover)
log:
    path: '/place/log/yandex/driver/driver.log'
    level: 'INFO'
    timings: '/place/log/yandex/driver/timings.log'
    root_log: '/logs/current-driver-root.log'
web:
    mode: 'unix'
    unixSocketPath: '/tmp/driver.sock'
    #tcpPort: 54321
repos:
    path: '/repo'
    configPathTemplate: '/etc/yandex-dinstall/{}.conf'
    cacusMarkerSection: 'DEFAULT'
    cacusSearchURLTemplate: 'http://localhost:1488/api/v1/conductor-search/{}?pkg={{}}&ver={{}}'
    dmoveTimeout: 60
    dmove34Retry: 60
    dmove34MinRetryCount: 1
    dmove34MaxRetryCount: 3
distributed_locks:
    zk_port: 2181
    zk_prefix: prod
    supress_zk_log: True
    zk_retry_limit: 5
    zk_nodes:
        - vs-logstorage01ht.yandex.ru
        - vs-logstorage02ht.yandex.ru
        - vs-logstorage03ht.yandex.ru
"""


def getDefaultConfig():
    """
    :rtype: dict
    """
    return yaml.load(default_config)


def getConfig(filename):
    """
    Parse provided file into dictionary.
    Raises (hopefully) ValueError or EnvironmentError
    :rtype: dict
    """
    try:
        with open(filename) as f:
            return yaml.load(f)
    except yaml.YAMLError as e:
        raise ValueError("failed to parse cfg file '{0}': "
                         "type='{1}' msg='{2}'".format(
                filename, e.__class__.__name__, str(e)))
