from .package import Package
from .repo import make_repo


class DmoveRequest(object):
    def __init__(self, context, data):
        """
        @type context: driver.context.Context
        """
        self.ctx = context

        if 'branch' not in data:
            raise ValueError
        self.target_branch = data['branch']
        self.repos = []
        self.packages = []
        if 'force' in data:
            self.force = data['force']
        else:
            self.force = False

        if 'repos' not in data:
            raise ValueError
        for name, repo_data in data['repos'].items():
            repo = make_repo(name, repo_data['info'], self.ctx)
            self.add_repo(repo)
            if 'packages' not in repo_data:
                raise ValueError
            for p_name, p_version in repo_data['packages']:
                package = Package(p_name, p_version, repo)
                self.add_package(package)

    def add_repo(self, repo):
        self.repos.append(repo)

    def add_package(self, pack):
        self.packages.append(pack)

    def packs_by_repo(self, repo):
        return filter(lambda x: x.repo == repo, self.packages)
