class Package(object):
    def __init__(self, name, version, repo):
        self.name = name
        self.version = version
        self.repo = repo

    @property
    def source_package(self):
        return SourcePackage(self.repo.detect_source_package(self), self.version, self.repo)

    def __repr__(self):
        return "%s=%s" % (self.name, self.version)

    def __hash__(self):
        return hash((self.name, self.version, hash(self.repo)))

    def __eq__(self, other):
        return (self.name, self.version) == (other.name, other.version) and self.repo == other.repo

    def __ne__(self, other):
        return not self.__eq__(other)

    def __gt__(self, other):
        if self.name == other.name:
            if self.version == other.version:
                return self.repo > other.repo
            else:
                return self.version > other.version
        else:
            return self.name > other.name

    def __lt__(self, other):
        if self.name == other.name:
            if self.version == other.version:
                return self.repo < other.repo
            else:
                return self.version < other.version
        else:
            return self.name < other.name

    def __le__(self, other):
        return self.__lt__(other) or self.__eq__(other)

    def __ge__(self, other):
        return self.__gt__(other) or self.__eq__(other)


class SourcePackage(Package):
    pass
