# Создание, сборка и подписывание пакета

В общем случае для создания пакета необходимо выполнить следующие действия:

1. Создать каталог определенной [структуры](Structure.md).
    
1. Разместить в этом каталоге файлы, предназначенные для распространения в пакете, и файлы, описывающие пакет (конфигурационные файлы, установочные скрипты и пр.).
    
1. Собрать пакет.
    
    Собранный пакет представляет собой архив с расширением `deb`. Этот файл содержит все данные, необходимые для установки пакета. Информация, описывающая пакет и необходимая для распространения пакета через репозиторий, находится в файлах с расширениями `dsc` и `changes`.
    
1. Подписать пакет. Подписывается не deb-архив, а файлы с расширением `dsc` и `changes`.

   На компьютере должно быть установлено специализированное [программное обеспечение](Software.md) и [сгенерирована пара GPG-ключей](GPG.md).
   
   1. Создайте рабочий каталог, в который будет помещаться собранный пакет. В него добавьте каталог пакета.
   
      Каталог пакета должен иметь суффикс «-\<version>», соответствующий версии собираемого пакета. В общем случае последнее требование не является обязательным. В данном примере для создания базовой структуры пакеты используется программа `dh_make`, которая определяет версию пакета по суффиксу каталога. Если название каталога не будет содержать указанного суффикса, использовать `dh_make` будет невозможно.
      
      {% note info %}
      
      Использование `dh_make` является наиболее распространенным, но не единственным способом формирования базовой структуры пакета. Перед использованием `dh_make` необходимо проконсультироваться с руководителем.
      
      {% endnote %}
      
      Будем использовать следующие названия:
      
      - название рабочего каталога — `packages`;
      - название пакета (и, соответственно, каталога пакета) — `mypackage`;
      - версия пакета — 1.0.
      
      ```no-highlight
      cd mkdir -p packages/mypackage-1.0 cd packages/mypackage-1.0
      ```
     
   1. Сгенерируйте базовую структуру пакета.
      
      ```no-highlight
      $ dh_make -c gpl -n
      
      Maintainer name : mylogin
      Email-Address   : mylogin@yandex-team.ru
      Date            : Thu, 27 Aug 2009 12:35:36 +0400
      Package Name    : mypackage
      Version         : 1.0
      License         : gpl
      Using dpatch    : no
      Using quilt     : no
      Type of Package : Single
      Hit <enter> to confirm:
      Currently there is no top level Makefile. This may require additional tuning.
      Done. Please edit the files in the debian/ subdirectory now. You should also
      check that the tt Makefiles install into $DESTDIR and not in / .
      ```
      
      В каталоге пакета будет сформирован подкаталог `debian`, содержащий шаблоны файлов, необходимых для сборки пакета.
      
   1. Внесите изменения в сформированные шаблоны.
      
      В данном примере рассматривается минимальное количество изменений в сгенерированных конфигурационных файлах, необходимых для сборки простого пакета — правки вносятся в файлы `control`, `changelog` и `rules`.
      
      `control`
      
      ```no-highlight
      Source: mypackage
      Section: misc                                           <<< unknown -> misc
      Priority: extra
      Maintainer: mylogin <mylogin@yandex-team.ru>
      Build-Depends: debhelper (>= 7)
      Standards-Version: 3.8.0
      Homepage: <insert the upstream URL, if relevant>
      
      Package: mypackage
      Architecture: all                                       <<< any -> all
      Depends: ${shlibs:Depends}, ${misc:Depends}
      Description: site.yandex.ru markup                      <<< Краткое описание пакета
      XSLT templates for site.yandex.ru                      <<< Расширенное описание пакета. Пробел в начале строки обязателен
      ```
      
      `rules`
      
      Файл `rules` обрабатывается программой `make` и его синтаксис должен соответствовать формату Makefile. Это, в частности, означает, что отступы от начала строки до инструкции (команды) могут состоять из символов табуляции, но не могут состоять из пробелов.
      
      В данный файл необходимо внести следующие правки: удалить или закомментировать с помощью символа # все строки, содержащие ссылку на переменную `$(MAKE)`. В раздел `install` нужно определить действия, которые необходимо совершить в процессе cборки пакета до его архивирования и подписывания. Например, если пакет будет содержать лишь каталог с файлами, который необходимо просто разместить в определенном месте, раздел `install` может выглядеть следующим образом:
      ```no-highlight
      install: build
      dh_testdir
      dh_testroot
      dh_prep
      dh_installdirs
      
      # Add here commands to install the package into debian/mypackage.
      #$(MAKE) DESTDIR=$(CURDIR)/debian/mypackage install
      mkdir -p $(CURDIR)/debian/mypackage/usr/local/www5
      cp -r /usr/local/www5/mypackage $(CURDIR)/debian/mypackage/usr/local/www5
      find $(CURDIR)/debian/mypackage/usr/local/www5/mypackage -name .svn | xargs rm -Rf
      ```
      
      Первая команда создает каталог, вторая — копирует в него распространяемый каталог, третья — очищает распространяемый каталог от служебных каталогов Subversion. Местоположение распространяемых файлов относительно каталога debian определяет их местоположение относительно корня в той файловой системе, куда устанавливается пакет.
      
      `changelog`
      
      Синтаксис файла `changelog` должен соответствовать [принятому формату](http://www.debian.org/doc/debian-policy/ch-source.html#s-dpkgchangelog). Чтобы не допустить синтаксических ошибок, для редактирования файла `changelog` следует использовать программу `dch`. При создании пакета данный файл редактировать не обязательно.
      ```no-highlight
      mypackage (1.0) unstable; urgency=low
      
      * Initial Release.
      *
      
      -- mylogin <mylogin@yandex-team.ru>  Thu, 27 Aug 2009 12:35:36 +0400
      ```
      
   1. Соберите и подпишите пакет.
      
      Для этого завершите работу всех программ (например, редакторов), которые могут в момент сборки осуществлять доступ к какому-нибудь из файлов в каталоге пакета. Далее запустите программу `debuild`.
      ```no-highlight
      debuild
      ```
      
      В процессе сборки дважды будет предложено ввести пароль для пары GPG-ключей, с помощью которой подписывается пакет.
      
      {% note info %}
      
      Для сборки пакетов может также быть использован [pbuilder](http://wiki.yandex-team.ru/JurijjNikulin/pbuilder), преимуществом которого является возможность сборки пакетов в чистом окружении без риска использования некорректной версии какого-либо пакета.
      
      {% endnote %}
      
      В результате в рабочем каталоге сформируется несколько файлов. Файл с расширением `deb` — собранный пакет. Файлы с расширениями `dsc` и `changes` содержат информацию, необходимую для распространения пакета через репозиторий и включают в себя электронную подпись.

- [Порядок сборки пакетов в Верстке](http://wiki.yandex-team.ru/verstka/methods/debianize)

- [Сборка пакетов с помощью pbuilder](http://wiki.yandex-team.ru/JurijjNikulin/pbuilder)
