# Создание GPG-ключей

Программные пакеты принято подписывать. Это позволяет установить, действительно ли данный пакет был подготовлен владельцем цифровой подписи и не отличается ли содержимое пакета от того, что использовалось при его сборке.

Для подписи дебиановских пакетов используется асимметричный алгоритм шифрования [OpenPGP](http://www.pgpru.com/), реализованный программным обеспечением проекта [GnuPG](http://ru.wikipedia.org/wiki/GnuPG) (GPG). При асимметричном шифровании используется два взаимосвязанных ключа — личный и публичный. Личный ключ используется для подписи пакета, публичный — для проверки владельца и неизменности содержимого пакета. Данная пара ключей генерируется с помощью программы GPG, которая также обеспечивает выполнение всех основных операций при работе с подписываемыми пакетами.

Ниже приведен пример генерирования пары GPG-ключей на Linux-машине. Последовательностью **<<<** помечены места ввода информации пользователем.

{% note warning %}

1. Минимальный допустимый размер ключа — 2048 бит.
1. Вывод команды может различаться в зависимости от используемой версии GnuPG.

{% endnote %}


```no-highlight
$ gpg --gen-key
gpg (GnuPG) 1.4.9; Copyright (C) 2008 Free Software Foundation, Inc.
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.

Выберите тип ключа:
   (1) DSA и ElGamal (по умолчанию)
   (2) DSA (только для подписи)
   (5) RSA (только для подписи)
Ваш выбор (?-подробнее)? 1                                                <<<
Пара ключей DSA будет иметь длину 1024 бит.
ключи ELG-E могут иметь длину от 1024 до 4096 бит.
Какой размер ключа Вам необходим? (2048)                                  <<<
Запрашиваемый размер ключа 2048 бит
Выберите срок действия ключа.
         0 = без ограничения срока действительности
      <n>  = срок действительности n дней
      <n>w = срок действительности n недель
      <n>m = срок действительности n месяцев
      <n>y = срок действительности n лет
Ключ действителен до? (0) 0
Ключ не имеет ограничения срока действительности
Все верно? (y/N) y                                                        <<<

Для идентификации Вашего ключа необходим User ID
Программа создаст его из Вашего имени, комментария и адреса e-mail в виде:
    "Baba Yaga (pensioner) <yaga@deepforest.ru>"

Ваше настоящее имя: Ivan Ivanov                                           <<<
Email-адрес: mylogin@yandex-team.ru                                       <<<
Комментарий: 
Вы выбрали следующий User ID:
    "Ivan Ivanov <mylogin@yandex-team.ru>"

Сменить (N)Имя, (C)Комментарий, (E)email-адрес или (O)Принять/(Q)Выход? O <<<
Для защиты секретного ключа необходим пароль.

Необходимо сгенерировать много случайных чисел. Желательно, что бы Вы
выполняли некоторые другие действия (печать на клавиатуре, движения мыши,
обращения к дискам) в процессе генерации; это даст генератору
случайных чисел возможность получить лучшую энтропию.
++++++++++++++++++++++++++++++++++++++++++++++++++.++++++++++.+++++...++++
+.++++++++++++++++++++.+++++++++++++++++++++++++++++++++++++++++++++......
.+++++
Необходимо сгенерировать много случайных чисел. Желательно, что бы Вы
выполняли некоторые другие действия (печать на клавиатуре, движения мыши,
обращения к дискам) в процессе генерации; это даст генератору
случайных чисел возможность получить лучшую энтропию.
.++++++++++.++++++++++.++++++++++.+++++++++++++++++++++++++.++++++++++.+++
+++++++++++++++++.++++++++++..+++++++++++++++..++++++++++.+++++++++++++++.
+++++.+++++>..++++++++++>..+++++........................+++++^^^
gpg: ключ 1A04ACEE помечен как абсолютно доверяемый.
открытый и закрытый ключи созданы и подписаны.

gpg: проверка таблицы доверий
gpg: 3 ограниченных необходимо, 1 выполненных необходимо, PGP модель доверия
gpg: глубина: 0  корректных:   1  подписанных:   0  доверия: 0-, 0q, 0n, 0m, 0f, 1u
pub   1024D/1A04ACEE 2009-08-20
      Отпечаток ключа = 22DB C72F 2E5E 2FEF D5CC  2AF6 F298 324C 1A04 ACEE
uid                  Ivan Ivanov <mylogin@yandex-team.ru>
sub   2048g/EC846BEC 2009-08-20
```

Более подробная информация о процессе генерирования пары GPG-ключей приведена на странице [http://www.citforum.ru/security/cryptography/gph/ch01.shtml](http://www.citforum.ru/security/cryptography/gph/ch01.shtml#id2535608).

Сгенерированные ключи помещаются в репозиторий ключей.

Программы, проверяющие подлинность содержимого и автора подписанного пакета, должны иметь доступ к публичному ключу. Программное обеспечение, регламентирующее доступ к загрузке пакетов в репозитории Яндекса, идентифицирует пользователей с помощью их публичных ключей и, соответственно, должно иметь доступ к этим ключам. Процедура получения доступа на загрузку пакетов в репозитории Яндекса описана в разделе [Загрузка пакета в репозиторий](Uploading.md).

Чтобы упростить процедуру подписывания пакетов, можно добавить в `~/.bashrc` следующие строки:

```no-highlight
export DEBFULLNAME="Ivan Ivanov"
export DEBEMAIL="mylogin@yandex-team.ru"
alias dch='dch --distributor=debian'
```

Первые две строки определяют параметры ключа, с помощью которого по умолчанию подписывается пакет. Последняя строка указывает программе `dch`, использующейся при редактировании списка изменений, не добавлять в версию пакета дополнительных префиксов и суффиксов.

