# Подготовка к работе с репозиториями

Обычно [доступ к загрузке пакетов](#repo-access) в репозиторий имеет ограниченный набор пользователей, которые идентифицируются по публичному GPG-ключу. К загрузке принимаются только пакеты, подписанные личным GPG-ключом, соответствующим публичному.

[Параметры загрузки](#dupload-conf) пакетов определяются в конфигурационному файле.

## Доступ к загрузке пакетов {#repo-access}

Репозитории, используемые для внутренней разработки Яндекса, размещены на сервере `dist.yandex.ru`.

Чтобы получить доступ к загрузке пакетов необходимо выполнить следующие действия:

1. Экспортировать публичный [GPG-ключ](GPG.md) в файл.
   
   - Если у вас один ключ, достаточно указать имя пользователя, для которого нужно экспортировать ключ. Например, для пользователя <q>ironman</q>:
   
      ```no-highlight
      gpg --export --armor ironman@yandex-team.ru >ironman.gpg
      ```
      
   - Если у вас несколько ключей, укажите id ключа, который нужно экспортировать. Например, для ключа `AAAAAA01`:
      
      ```
      gpg --output pubkey.gpg --armor --export AAAAAA01
      ```
      
      {% note info %}
      
      Чтобы просмотреть список ключей, воспользуйтесь командой:
      ```
      gpg --list-keys
      ```
      
      {% endnote %}
      
1. Добавить содержимое полученного файла на Стафф.
    
    Для этого нужно открыть форму добавления (**GPG-ключи** → **Редактировать** → **Добавить ключ**) и заполнить поля:
    
    - **Ключ** — содержимое файла с публичным GPG-ключом.
    - **Описание** — информация о ключе в свободной форме.
    
1. (_Опц._) Запросить доступ для загрузки пакетов в закрытые репозитории на рассылке [dist@yandex-team.ru](mailto:dist@yandex-team.ru).
    
    Список закрытых репозиториев представлен на странице [https://staff.yandex-team.ru/groups/?query=gpg&page=1](https://staff.yandex-team.ru/groups/?query=gpg&page=1). Доступ ко всем репозиториям, кроме указанных на данной странице, предоставляется по умолчанию после добавления ключа на Стафф (запрашивать доступ к ним не нужно).
    

Список репозиториев Яндекса приведен на странице [https://wiki.yandex-team.ru/YandexRepos#repos](https://wiki.yandex-team.ru/YandexRepos#repos).

{% note info %}

Доступ для загрузки пакетов на сервер `secdist.yandex.net` запрашивается через сотрудников службы информационной безопасности (см. [описание в Вики](https://wiki.yandex-team.ru/security)).

{% endnote %}


## Параметры загрузки {#dupload-conf}

Для загрузки пакетов в репозитории используется программа `dupload`. Список репозиториев, доступ к ним и прочие параметры загрузки определяются в конфигурационном файле. По умолчанию `dupload` использует конфигурационный файл с именем `.dupload.conf`, который находится в домашнем каталоге пользователя (`~/.dupload.conf`).

{% note info %}

Вместо пользовательского `.dupload.conf` может использоваться глобальный. Перед внесением любых изменений необходимо проконсультироваться с руководителем.

{% endnote %}

> # Пример конфигурационного файла
> 
> ```no-highlight
> package config;
> 
> $default_host = "verstka";
> 
> $cfg{'verstka'} = {
>     fqdn => "verstka.dupload.dist.yandex.ru",
>     method => "scpb",
>     incoming => "/repo/verstka/mini-dinstall/incoming/",
>     dinstall_runs => 0,
> };
> 
> $cfg{'yandex-hardy'} = {
>     fqdn => "yandex-hardy.dupload.dist.yandex.ru",
>     method => "scpb",
>     incoming => "/repo/yandex-hardy/mini-dinstall/incoming/",
>     dinstall_runs => 0,
> };
> ```

По умолчанию `dupload` полагает, что загрузка производится от имени пользователя, учетная запись которого используется для загрузки пакета. Если это имя пользователя не совпадает с именем пользователя, публичный ключ которого используется для загрузки пакетов, в пользовательский конфигурационный файл необходимо добавить строку следующего вида:
```no-highlight
$cfg{"verstka"}{"login"} = "mylogin"
```

