# Программное обеспечение

Разработчики Debian приводят следующий список программного обеспечения, необходимый для сборки пакетов.

{% note info %}

Обязательные пакеты требуются для работы примеров, приведенных в данном документе.

{% endnote %}

Пакет | Описание
----- | -----
**Обязательные пакеты**
`dh-make` | Программа для построения базовой структуры дебиановского пакета.
`debhelper` | Набор программ, упрощающих решение типовых задач, возникающих при сборке дебиановских пакетов.
`devscripts` | Набор программ, помогающих при сборке дебиановских пакетов. Содержит программу `debuild`, осуществляющую окончательную сборку пакета.
`fakeroot` | Программа, позволяющая обычному пользователю выполнять действия, требующие привилегий суперпользователя (root), в изолированном окружении без возможности изменить внешние файлы.
`gnupg` | Криптографическое приложение поддерживающие алгоритм шифрования OpenPGP. Используется для подписывания пакетов и работы с подписанными пакетами.
`lintian` | Программа для проверки пакета на наличие в нем типовых ошибок.
**Стандартные**
`dpkg-dev` | Набор программ для сборки и распаковки пакетов, а также для загрузки пакетов в репозиторий.
`file` | Программа для определения типа файла.
`gcc` | Компилятор GNU C.
`g++` | Компилятор GNU C++.
`libc6-dev` | Библиотеки и заголовочные файлы, используемые `gcc`.
`make` | Программа, автоматизирующая процесс компиляции и сборки программ из исходных кодов.
`patch` | Программа, вносящая в файл изменения, которые были произведены начиная с более старой версии файла. Список изменений генерируется программой diff.
`perl` | Интерпретатор языка Perl.
**Дополнительные**
`autoconf` | Программа для создания скриптов, которые автоматически конфигурируют пакеты с исходным кодом так, чтобы они могли работать на множестве UNIX-подобных систем.
`automake` | Программа для генерации make-файлов, соответствующих спецификации GNU Makefile (т. е. пригодных для обработки на любой UNIX-подобной системе).
`g77` | Компилятор GNU Fortran 77.
`gpc` | Компилятор GNU Pascal 77.
`xutils` | Набор программ, реализующих некоторые возможности X Window System. Пакет часто используется для плавного перехода с ранних выпусков Debian на более поздние версии.
`pbuilder` | Набор программ для создания и поддержки окружения chroot.

Список пакетов, приведенных в разделе [Стандартные](Software.md#Standard), входит в стандартные дистрибутивы Debian (и дистрибутивы, основанные на Debian, такие как Ubuntu).

Проверить, установлен ли пакет с именем `packagename`, можно командой:
```no-highlight
dpkg -s packagename
```

Просмотреть список всех пакетов, установленных в системе, можно с помощью команды
```no-highlight
dpkg -l
```

Для загрузки пакетов в репозиторий необходимо установить пакет `dupload`, содержащий одноименную программу.
